# -*- coding: utf-8 -*-
from odoo import fields, models


class AccountAssetDefault(models.Model):
    _name = "account.asset.default"

    ################################################################################
    # Fields
    ################################################################################

    company_id = fields.Many2one('res.company', required=True, readonly=True,
                                 default=lambda self: self.env.user.company_id)

    autopost_depreciation_journal = fields.Boolean(string="Auto-Post Depreciation Journal")
    loss_on_disposal_account = fields.Many2one(comodel_name='account.account', string='Loss on disposal account')
    journal = fields.Many2one(comodel_name='account.journal', string='Disposal Journal')
    invoice_journal = fields.Many2one(comodel_name='account.journal', string='Invoice Journal')

    asset_sale_suspense_account = fields.Many2one(comodel_name='account.account', string='Asset Sale Suspense Account',
                                                  help='This account will be debited from '
                                                       'the asset sale journal and credited from the '
                                                       'invoice generated or receipt')

    gain_on_disposal_account = fields.Many2one(comodel_name='account.account', string='Depreciation Recovered Account',
                                               help='If not specified, depreciation account is used ')

    capital_gain_account = fields.Many2one(comodel_name='account.account', string='Capital Gain disposal account')
    sale_product = fields.Many2one(comodel_name='product.product', string='Sale Product',
                                   help='This should have no GST on sale')
    impairment_loss = fields.Many2one(comodel_name='account.account', string='Impairment Loss')
